
require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

PlaySound("audio/sfx/menu/switch_screen.ogg");

kButtonSpacing = 45;
kButtonY = 195;
kButtonX = 0;

function CheckUsers()
	if (GetNumUsers() == 0) then
		gEnterNameValue = "";
		name = DoModal("scripts/entername.lua");
		if (not(name == nil)) then
			CreateNewUser(name);
			return true ;
		end
		return false;
	else
		return true;
	end
end

function QuitGame()
	CloseWindow();
end

function CreateMenuButtonText(label, color, size, x, y)
    return Group({
        SetStyle(CreateTextStyle(FontButtons, size, DarkGrayColor)),
        CreateText(x, y, label, 2, 4),
        SetStyle(CreateTextStyle(FontButtons, size, BlackColor)),
        CreateText(x, y, label, 1, 2),
        SetStyle(CreateTextStyle(FontButtons, size, color)),
        CreateText(x, y, label, 0, 0),
    })
end

MakeDialog
{
	-- Name the modal dialog
	name="mainmenu",
	MainMenu
	{
		fit=true;
		Bitmap
		{
			name="backgroundimage",
			image="ui/surfaces/mainmenu",

			SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
			Text
			{
			    flags=kVAlignTop + kHAlignCenter,
				name = "welcome_shadow",
				x=3,y=525,w=kMax,h=kMax,
				label = "welcome"
			},

						
			SetStyle(CreateTextStyle(FontGame, 24, WhiteColor)),
			Text
			{
			    flags=kVAlignTop + kHAlignCenter,
				name = "welcome",
				x=1,y=523,w=kMax,h=kMax,
				label = "welcome"
			},
	
			SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
			Text
			{
			    flags=kVAlignTop + kHAlignLeft,
				name = "copyright",
				x=16,y=581,w=kMax,h=kMax,
				label = "copyright"
			},
			SetStyle(CreateTextStyle(FontGame, 16, WhiteColor)),
			Text
			{
			    flags=kVAlignTop + kHAlignLeft,
				name = "copyright",
				x=15,y=580,w=kMax,h=kMax,
				label = "copyright"
			},

			SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=356,
				y=82,
				w=90, h=84,
				name="gamemode1",
				command=
					function()
						if (CheckUsers()) then
							SetCurrentGameMode(0);
							PlaySound("audio/sfx/menu/switch_screen.ogg");
							SwapToModal("scripts/chooserestaurant.lua");
						end
					end,
				SelectLayer(0),
				CreateMenuButtonText("storylabel", VeryLightBlueColor, 40, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("storylabel", VeryLightBlueColor, 40, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("storylabel", WhiteColor, 40, 5, 0),
			},


            -- fake button
            --[[
			SetStyle(CreatePushButtonStyle(NoButtonGraphics, NoButtonSound)),
			Button
			{
				x=456,
				y=30,
				w=90, h=80,
				SelectLayer(0),
				CreateMenuButtonText("endlesslabel", DarkGrayColor, 34, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("endlesslabel", DarkGrayColor, 34, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("endlesslabel", DarkGrayColor, 34, 5, 0),
			},
                            --]]

            SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
            SelectLayer(0),
			Button
			{
				x=456,
				y=30,
				w=90, h=80,
				name="gamemode2",
				command=
					function()
						if (CheckUsers()) then
							SetCurrentGameMode(1);
							PlaySound("audio/sfx/menu/switch_screen.ogg");
							SwapToModal("scripts/chooserestaurant.lua");
						end
					end,

				SelectLayer(0),
				CreateMenuButtonText("endlesslabel", LightBlueColor, 32, 5, 0),
				
				SelectLayer(1),
				CreateMenuButtonText("endlesslabel", LightBlueColor, 32, 5, 0),
				
				SelectLayer(2),
				CreateMenuButtonText("endlesslabel", WhiteColor, 32, 5, 0),
			},

			SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=557,
				y=73,
				w=90, h=30,
				name="highscores",
				command=
					function()
					    PlaySound("audio/sfx/menu/switch_screen.ogg");
						SwapToModal("scripts/hiscore.lua");
					end,
				SelectLayer(0),
				CreateMenuButtonText("highscores", LightBlueColor, 23, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("highscores", LightBlueColor, 23, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("highscores", WhiteColor, 23, 5, 0),
			},

			SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=558,
				y=43,
				w=90, h=30,
				name="medals",
				command=
					function()
					    PlaySound("audio/sfx/menu/switch_screen.ogg");
						DoModal("scripts/medals.lua");
					end,
				SelectLayer(0),
				CreateMenuButtonText("medals", LightBlueColor, 26, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("medals", LightBlueColor, 26, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("medals", WhiteColor, 26, 5, 0),
			},

			SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=647,
				y=68,
				w=90, h=30,
				name="options",
				command=
					function()
					    PlaySound("audio/sfx/menu/switch_screen.ogg");
						DoModal("scripts/options.lua");
					end,
				SelectLayer(0),
				CreateMenuButtonText("options", LightBlueColor, 26, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("options", LightBlueColor, 26, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("options", WhiteColor, 26, 5, 0),
			},

			SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=648,
				y=100,
				w=90, h=30,
				name="help",
				command=
					function()
					    PlaySound("audio/sfx/menu/switch_screen.ogg");
						DoModal("scripts/help1.lua");
					end,
				SelectLayer(0),
				CreateMenuButtonText("help", LightBlueColor, 28, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("help", LightBlueColor, 28, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("help", WhiteColor, 28, 5, 0),
			},

			SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=620,
				y=550,
				name="moregames",
	            command=
		            function()
		                PlaySound("audio/sfx/menu/switch_screen.ogg");
			            DoModal("xsell/xsell.lua");
		            end,
				SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				CreateText(2,2,"moregames", 0, 0),
				SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				CreateText(0,0,"moregames", 0, 0),

			},

			SetStyle(CreatePushButtonStyle(NoButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=715,
				y=36,
				w=90, h=30,
				name="quit",
				command=
					function()
					    PlaySound("audio/sfx/menu/switch_screen.ogg");
					    DoModal("scripts/quitwindow.lua");
					end,
				SelectLayer(0),
				CreateMenuButtonText("quit", LightBlueColor, 26, 5, 0),
				SelectLayer(1),
				CreateMenuButtonText("quit", LightBlueColor, 26, 5, 0),
				SelectLayer(2),
				CreateMenuButtonText("quit", WhiteColor, 26, 5, 0),
			},
            
			SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
			Button
			{
				x=340,
				y=550,
				name="changeplayer",
				command=
					function()
						DoModal("scripts/chooseplayer.lua");
					end,

				SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
				CreateText(2,2,"changeplayer", 0, 0),
				SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
				CreateText(0,0,"changeplayer", 0, 0),

			},
		},
	}
}